/*
 * Decompiled with CFR 0.152.
 */
package vectorwing.farmersdelight.data.recipes;

import java.util.function.Consumer;
import java.util.stream.Stream;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.item.crafting.Ingredient;
import net.minecraft.tags.ITag;
import net.minecraft.util.IItemProvider;
import vectorwing.farmersdelight.data.builder.CookingPotRecipeBuilder;
import vectorwing.farmersdelight.registry.ModItems;
import vectorwing.farmersdelight.utils.tags.ForgeTags;
import vectorwing.farmersdelight.utils.tags.ModTags;

public class CookingRecipes {
    public static final int FAST_COOKING_TIME = 100;
    public static final int SLOW_COOKING_TIME = 400;

    public static void register(Consumer<IFinishedRecipe> consumer) {
        CookingRecipes.cookMiscellaneous(consumer);
        CookingRecipes.cookMinecraftSoups(consumer);
        CookingRecipes.cookMeals(consumer);
    }

    private static void cookMiscellaneous(Consumer<IFinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.HOT_COCOA.get(), 1).addIngredient((ITag<Item>)ForgeTags.MILK).addIngredient((IItemProvider)Items.field_151102_aT).addIngredient((IItemProvider)Items.field_196130_bo).addIngredient((IItemProvider)Items.field_196130_bo).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.TOMATO_SAUCE.get(), 1, 100).addIngredient((ITag<Item>)ForgeTags.CROPS_TOMATO).addIngredient((ITag<Item>)ForgeTags.CROPS_TOMATO).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.DOG_FOOD.get(), 1).addIngredient((IItemProvider)Items.field_151078_bh).addIngredient((IItemProvider)Items.field_196106_bc).addIngredient((ITag<Item>)ModTags.WOLF_PREY).addIngredient((ITag<Item>)ForgeTags.CROPS_RICE).build(consumer);
    }

    private static void cookMinecraftSoups(Consumer<IFinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)Items.field_151009_A, 1, (IItemProvider)Items.field_151054_z).addIngredient((IItemProvider)Items.field_221692_bh).addIngredient((IItemProvider)Items.field_221694_bi).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)Items.field_185165_cW, 1, (IItemProvider)Items.field_151054_z).addIngredient((IItemProvider)Items.field_185164_cV).addIngredient((IItemProvider)Items.field_185164_cV).addIngredient((IItemProvider)Items.field_185164_cV).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)Items.field_179560_bq, 1, (IItemProvider)Items.field_151054_z).addIngredient((IItemProvider)Items.field_151168_bH).addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_179558_bo, Items.field_179559_bp})).addIngredient((IItemProvider)Items.field_151172_bF).addIngredient(Ingredient.func_199804_a((IItemProvider[])new IItemProvider[]{Items.field_221692_bh, Items.field_221694_bi})).build(consumer);
    }

    private static void cookMeals(Consumer<IFinishedRecipe> consumer) {
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.BAKED_COD_STEW.get(), 1).addIngredient((ITag<Item>)ForgeTags.RAW_FISHES_COD).addIngredient((IItemProvider)Items.field_151174_bG).addIngredient((ITag<Item>)ForgeTags.EGGS).addIngredient((ITag<Item>)ForgeTags.CROPS_TOMATO).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.BEEF_STEW.get(), 1).addIngredient((ITag<Item>)ForgeTags.RAW_BEEF).addIngredient((IItemProvider)Items.field_151172_bF).addIngredient((IItemProvider)Items.field_151174_bG).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.CABBAGE_ROLLS.get(), 1, 100).addIngredient((ITag<Item>)ForgeTags.CROPS_CABBAGE).addIngredient((ITag<Item>)ModTags.CABBAGE_ROLL_INGREDIENTS).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.CHICKEN_SOUP.get(), 1).addIngredient((ITag<Item>)ForgeTags.RAW_CHICKEN).addIngredient((IItemProvider)Items.field_151172_bF).addIngredient((ITag<Item>)ForgeTags.SALAD_INGREDIENTS).addIngredient((ITag<Item>)ForgeTags.VEGETABLES).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.COOKED_RICE.get(), 1, 100).addIngredient((ITag<Item>)ForgeTags.CROPS_RICE).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.DUMPLINGS.get(), 2).addIngredient((ITag<Item>)ForgeTags.PASTA).addIngredient((ITag<Item>)ForgeTags.CROPS_CABBAGE).addIngredient((ITag<Item>)ForgeTags.CROPS_ONION).addIngredient(Ingredient.func_209357_a(Stream.of(new Ingredient.TagList(ForgeTags.RAW_CHICKEN), new Ingredient.TagList(ForgeTags.RAW_PORK), new Ingredient.TagList(ForgeTags.RAW_BEEF), new Ingredient.SingleItemList(new ItemStack((IItemProvider)Items.field_221692_bh))))).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.FISH_STEW.get(), 1).addIngredient((ITag<Item>)ForgeTags.RAW_FISHES).addIngredient((IItemProvider)ModItems.TOMATO_SAUCE.get()).addIngredient((ITag<Item>)ForgeTags.CROPS_ONION).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.FRIED_RICE.get(), 1).addIngredient((ITag<Item>)ForgeTags.CROPS_RICE).addIngredient((ITag<Item>)ForgeTags.EGGS).addIngredient((IItemProvider)Items.field_151172_bF).addIngredient((ITag<Item>)ForgeTags.CROPS_ONION).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.NOODLE_SOUP.get(), 1).addIngredient((ITag<Item>)ForgeTags.PASTA).addIngredient((ITag<Item>)ForgeTags.COOKED_EGGS).addIngredient((IItemProvider)Items.field_203180_bP).addIngredient((ITag<Item>)ForgeTags.RAW_PORK).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.PASTA_WITH_MEATBALLS.get(), 1).addIngredient((IItemProvider)ModItems.MINCED_BEEF.get()).addIngredient((ITag<Item>)ForgeTags.PASTA).addIngredient((IItemProvider)ModItems.TOMATO_SAUCE.get()).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.PASTA_WITH_MUTTON_CHOP.get(), 1).addIngredient((ITag<Item>)ForgeTags.RAW_MUTTON).addIngredient((ITag<Item>)ForgeTags.PASTA).addIngredient((IItemProvider)ModItems.TOMATO_SAUCE.get()).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.PUMPKIN_SOUP.get(), 1).addIngredient((IItemProvider)ModItems.PUMPKIN_SLICE.get()).addIngredient((ITag<Item>)ForgeTags.SALAD_INGREDIENTS).addIngredient((ITag<Item>)ForgeTags.RAW_PORK).addIngredient((ITag<Item>)ForgeTags.MILK).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.RATATOUILLE.get(), 1).addIngredient((ITag<Item>)ForgeTags.CROPS_TOMATO).addIngredient((ITag<Item>)ForgeTags.CROPS_ONION).addIngredient((IItemProvider)Items.field_185164_cV).addIngredient((ITag<Item>)ForgeTags.VEGETABLES).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.SQUID_INK_PASTA.get(), 1).addIngredient((ITag<Item>)ForgeTags.RAW_FISHES).addIngredient((ITag<Item>)ForgeTags.PASTA).addIngredient((ITag<Item>)ForgeTags.CROPS_TOMATO).addIngredient((IItemProvider)Items.field_196136_br).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.STUFFED_PUMPKIN_BLOCK.get(), 1, (IItemProvider)Items.field_221687_cF, 400).addIngredient((ITag<Item>)ForgeTags.CROPS_RICE).addIngredient((ITag<Item>)ForgeTags.VEGETABLES).addIngredient((IItemProvider)ModItems.TOMATO_SAUCE.get()).addIngredient((IItemProvider)Items.field_151168_bH).addIngredient((IItemProvider)ModItems.BROWN_MUSHROOM_COLONY.get()).addIngredient((IItemProvider)Items.field_222112_pR).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.VEGETABLE_NOODLES.get(), 1).addIngredient((IItemProvider)Items.field_151172_bF).addIngredient((IItemProvider)Items.field_221692_bh).addIngredient((ITag<Item>)ForgeTags.PASTA).addIngredient((ITag<Item>)ForgeTags.SALAD_INGREDIENTS).addIngredient((ITag<Item>)ForgeTags.VEGETABLES).build(consumer);
        CookingPotRecipeBuilder.cookingRecipe((IItemProvider)ModItems.VEGETABLE_SOUP.get(), 1).addIngredient((IItemProvider)Items.field_151172_bF).addIngredient((IItemProvider)Items.field_151174_bG).addIngredient((IItemProvider)Items.field_185164_cV).addIngredient((ITag<Item>)ForgeTags.SALAD_INGREDIENTS).build(consumer);
    }
}

